<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

header("Content-Type: application/json");

// Handle preflight CORS
if ($_SERVER["REQUEST_METHOD"] === "OPTIONS") {
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: POST");
    header("Access-Control-Allow-Headers: Content-Type");
    header("Access-Control-Max-Age: 86400");
    http_response_code(200);
    exit;
}

if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    http_response_code(405);
    echo json_encode(["message" => "Method Not Allowed"]);
    exit;
}

// Get and decode input
$data = json_decode(file_get_contents("php://input"), true);
$errors = [];

// Simple validation
if (empty($data['name'])) $errors['name'] = "Name is required";
if (empty($data['email']) || !filter_var($data['email'], FILTER_VALIDATE_EMAIL)) $errors['email'] = "Valid email is required";
if (empty($data['message'])) $errors['message'] = "Message is required";

if (!empty($errors)) {
    http_response_code(400);
    echo json_encode(['errors' => $errors]);
    exit;
}

// Sanitize
$name = htmlspecialchars($data['name']);
$email = htmlspecialchars($data['email']);
$message = nl2br(htmlspecialchars($data['message']));

// Compose HTML email
$htmlBody = "
<!DOCTYPE html>
<html>
<head><title>Contact Form Message</title></head>
<body>
<h2>New Contact Message</h2>
<p><strong>Name:</strong> {$name}</p>
<p><strong>Email:</strong> {$email}</p>
<p><strong>Message:</strong><br>{$message}</p>
</body>
</html>
";

$mail = new PHPMailer(true);

try {
    $mail->isSMTP();
    $mail->Host = 'mail.valleysafaris.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'admin@valleysafaris.com';
    $mail->Password = 'OYqKhNmc4evc5'; // Store this securely
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
    $mail->Port = 465;

    $mail->setFrom('admin@valleysafaris.com', 'Valley Safaris');
    $mail->addAddress('Bantulouto1@gmail.com', 'Valley Safaris');
    $mail->addAddress('micahlordia@gmail.com');

    $mail->isHTML(true);
    $mail->Subject = 'New Contact Message';
    $mail->Body = $htmlBody;

    $mail->send();
    echo json_encode(['message' => 'Message sent successfully!']);
} catch (Exception $e) {
    http_response_code(500);
    error_log("Mailer Error: " . $mail->ErrorInfo);
    echo json_encode(['message' => 'Error sending message. Please try again later.']);
}
